/*
 * @(#)ResponseBubble.java  1.0  23. M�rz 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.diagrambsh;

import ch.hslu.cm.*;
import ch.hslu.cm.oo.*;
import ch.randelshofer.util.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.awt.geom.*;
import java.util.*;
import static org.jhotdraw.draw.AttributeKeys.*;
import org.jhotdraw.draw.*;
import org.jhotdraw.geom.*;
/**
 * ResponseBubble visually represents a response of an object to a message.
 *
 * @author  Werner Randelshofer
 * @version 1.0 23. M�rz 2004  Created.
 */
public class ResponseBubble extends AbstractAttributedFigure {
    protected Figure parentFigure;
    protected BezierPath polygon;
    private String text;
    
    /** Creates a new instance. */
    public ResponseBubble(Figure parentFigure, Object response, boolean isException) {
        this.parentFigure = parentFigure;
        text = ""+response;
        
        if (isException) {
            FILL_COLOR.set(this, ClassDiagram.EXCEPTION_FILL_COLOR);
            STROKE_COLOR.set(this, ClassDiagram.EXCEPTION_STROKE_COLOR);
        } else {
            FILL_COLOR.set(this, ClassDiagram.RESPONSE_FILL_COLOR);
            STROKE_COLOR.set(this, ClassDiagram.RESPONSE_STROKE_COLOR);
        }
        invalidate();
    }
    
    protected void drawFill(java.awt.Graphics2D g) {
        g.fill(getBezierPath());
    }
    
    protected void drawStroke(java.awt.Graphics2D g) {
        g.draw(getBezierPath());
    }
    
    private Insets2D.Double getInsets() {
        double sw = STROKE_WIDTH.get(this);
        return new Insets2D.Double(2+sw, 4+sw, 2+sw, 4+sw);
    }
    
    protected void drawText(java.awt.Graphics2D g) {
        Rectangle2D.Double b = getBounds();
        Insets2D.Double insets = getInsets();
        TextLayout[] layouts = getMultilineTextLayouts();
        float y = (float) (b.y + insets.top);
        for (int i=0; i < layouts.length; i++) {
            layouts[i].draw(g, (float) (b.x + insets.left), y +  layouts[i].getAscent());
            y += layouts[i].getAscent()+layouts[i].getDescent()+layouts[i].getLeading();
        }
    }
    
    public Rectangle2D.Double getBounds() {
        Rectangle2D r = getBezierPath().getBounds2D();
        return new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }
    
    public void invalidate() {
        polygon = null;
        super.invalidate();
    }
    private BezierPath getBezierPath() {
        if (parentFigure == null) return new BezierPath();
        
        if (polygon == null) {
            BezierPath p = new BezierPath();
            
            Rectangle2D.Double parentBounds = parentFigure.getBounds();
            Rectangle2D.Double bubbleBounds = new Rectangle2D.Double(0,0,100,20);
            
            Dimension textDim = getMultilineDimension(getMultilineTextLayouts());
            Insets2D.Double insets = getInsets();
            bubbleBounds.width = textDim.width + insets.left + insets.right;
            bubbleBounds.height = textDim.height + insets.top + insets.bottom;
            bubbleBounds.x = parentBounds.x + parentBounds.width / 2 - bubbleBounds.width / 2;
            bubbleBounds.y = parentBounds.y - bubbleBounds.height - 12;
            
            /*
            g.setFont(Diagram.RESPONSE_SMALL_FONT);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D.Double sb = getStringBounds(label, getView(), Diagram.RESPONSE_SMALL_FONT);
             */
            p.add(bubbleBounds.x, bubbleBounds.y);
            p.add(bubbleBounds.x + bubbleBounds.width - 1, bubbleBounds.y);
            p.add(bubbleBounds.x + bubbleBounds.width - 1, bubbleBounds.y + bubbleBounds.height - 1);
            p.add(bubbleBounds.x + bubbleBounds.width / 2, bubbleBounds.y + bubbleBounds.height - 1);
            p.add(parentBounds.x + parentBounds.width / 2, parentBounds.y + 4);
            p.add(bubbleBounds.x + bubbleBounds.width / 2 - 10, bubbleBounds.y + bubbleBounds.height - 1);
            p.add(bubbleBounds.x, bubbleBounds.y + bubbleBounds.height - 1);
            polygon = p;
        }
        return polygon;
    }
    
    protected Dimension getMultilineDimension(TextLayout[] layouts) {
        float width = 0;
        float height = 0;
        for (int i=0; i < layouts.length; i++) {
            width = Math.max(width, (int) layouts[i].getAdvance());
            height += layouts[i].getAscent()+layouts[i].getDescent()+layouts[i].getLeading();
        }
        return new Dimension((int) width, (int) height);
    }
    protected TextLayout[] getMultilineTextLayouts() {
        String txt = text;
        if (txt == null || text.length() == 0) {
            txt = " ";
        }
        
        StringTokenizer tt = new StringTokenizer(txt, "\n");
        TextLayout[] layouts = new TextLayout[tt.countTokens()];
        for (int i=0; i < layouts.length; i++) {
            String line = tt.nextToken();
            if (line.length() == 0) line = " ";
            layouts[i] = getTextLayout(line);
        }
        return layouts;
    }
    
    protected TextLayout getTextLayout(String line) {
        HashMap<TextAttribute,Object> textAttributes = new HashMap<TextAttribute,Object>();
        textAttributes.put(TextAttribute.FONT, AttributeKeys.getFont(this));
        if (FONT_UNDERLINE.get(this)) {
            textAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        return new TextLayout(line, textAttributes, getFontRenderContext());
    }
    
    public void transform(AffineTransform tx) {
        invalidate();
    }
    
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        invalidate();
    }
    
    public boolean contains(Point2D.Double p) {
        return getBezierPath().contains(p);
    }
    public int getLayer() {
        return ClassDiagram.MESSAGE_LAYER;
    }
    public void restoreTransformTo(Object geometry) {
        BezierPath r = (BezierPath) geometry;
        polygon = (BezierPath) r.clone();
    }

    public Object getTransformRestoreData() {
        return polygon.clone();
    }
}
